/****************************************************
 * siliCAT.h
 *
 * siliCAT stack 1.1
 * for communication with SLC1044 and SLC1045
 *
 * 31.12.2008
 * G. Bartelt
 * www.sebulli.com
 ****************************************************/


/****************************************************
 * special siliCAT Ids
 ****************************************************/
#define siliCAT_RELOADED 1000 // is send when reloading a page
#define siliCAT_ALERT 1001    // send alert message
#define siliCAT_RELOAD 1002   // reload a page


/****************************************************
 * constants
 ****************************************************/
#define siliCAT_DATA         0x20
#define siliCAT_COMMAND      0x30
#define siliCAT_1stDATABYTE  (siliCAT_DATA | 0x00)
#define siliCAT_nthDATABYTE  (siliCAT_DATA | 0x04)
#define siliCAT_BYTEMSB      0x00
#define siliCAT_BYTELSB      0x80
#define siliCAT_MASK_1STDATA 0xBC
#define siliCAT_MASK_DATALM  0x98
#define siliCAT_TYPE_BYTE    0
#define siliCAT_TYPE_INT     1
#define siliCAT_TYPE_LONG    2
#define siliCAT_TYPE_STRING  3
#define siliCAT_TYPE_BUTTON  4
#define siliCAT_TYPE_VISIBILITY 5
#define siliCAT_TYPE_LIST    6
#define siliCAT_TYPE_BYTES   7



/****************************************************
 * callback functions
 ****************************************************/
void siliCAT_RxValue(unsigned int id,unsigned long value,char* rxstrbuf);
void siliCAT_TxByte(unsigned char b);


/****************************************************
 * public function
 ****************************************************/
void siliCAT_SetSignedByte(unsigned int id,signed char sb);
void siliCAT_SetSignedInt(unsigned int id,signed int si);
void siliCAT_SetSignedLong(unsigned int id,signed long sl);
void siliCAT_SetString(unsigned int id,/*rom*/ char* s);
void siliCAT_SetSignedBytes(unsigned int id,unsigned char l,signed char* bytes);
void siliCAT_SetVisibility(unsigned int id,unsigned char v);
void siliCAT_ListAdd(unsigned int id,char* s);
void siliCAT_ListRemove(unsigned int id,char* s);
void siliCAT_ListClear(unsigned int id);

void siliCAT_RxByte(unsigned char b);
